/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.attribute.IValueFormatter;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.api.common.skill.ITickableSkill;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.attribute.AttributeModifier;
import dev.toma.gunsrpg.common.attribute.AttributeOps;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class AdrenalineRushSkill
extends SimpleSkill
implements ITickableSkill,
IDescriptionProvider {
    private static final float[] MODIFIERS = new float[]{0.15f, 0.3f, 0.5f};
    private static final int HEALTH_LIMIT = 8;
    private final DescriptionContainer container;
    private final IAttributeModifier cooldownModifier;
    private final IAttributeModifier reloadModifier;
    private boolean isApplied;

    public AdrenalineRushSkill(SkillType<?> type, int level, float reloadMultiplier) {
        super(type);
        this.cooldownModifier = new AttributeModifier("EC2FBF66-9F72-417B-AF43-91EA879FCC1A", AttributeOps.MULB, (double)MODIFIERS[level]);
        this.reloadModifier = new AttributeModifier("808184F6-B4BC-4981-9A96-B28E3AF945B6", AttributeOps.MUL, (double)reloadMultiplier);
        this.container = new DescriptionContainer(type);
        this.container.addProperty("predicate", 8);
        this.container.addProperty("attack", IValueFormatter.PERCENT.formatAttributeValue(this.cooldownModifier.getModifierValue()));
        this.container.addProperty("reload", IValueFormatter.INV_PERCENT.formatAttributeValue(this.reloadModifier.getModifierValue()));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        boolean wasApplied = this.isApplied;
        this.isApplied = this.canApply(player);
        if (wasApplied != this.isApplied) {
            BiConsumer<IAttribute, IAttributeModifier> operation = this.isApplied ? IAttribute::addModifier : IAttribute::removeModifier;
            PlayerData.get(player).ifPresent(data -> {
                IAttributeProvider provider = data.getAttributes();
                IAttribute attackSpeed = provider.getAttribute(Attribs.MELEE_COOLDOWN);
                IAttribute reloadSpeed = provider.getAttribute(Attribs.RELOAD_SPEED);
                operation.accept(attackSpeed, this.cooldownModifier);
                operation.accept(reloadSpeed, this.reloadModifier);
            });
        }
    }

    @Override
    public boolean canApply(PlayerEntity user) {
        return user.func_110143_aJ() <= 8.0f;
    }
}

